import json
from saas.tools.abcd.app.app import prepare_flask_app
from saas.tools.abcd.api.blueprints import saas_quota_handles


class SaaSQuotaConnector(object):
    app = prepare_flask_app(env_type="production")

    @classmethod
    def get_quotas(cls):
        with cls.app.app_context():
            result = json.loads(saas_quota_handles.list_quota_accounts().get_data())
        return result

    @classmethod
    def get_quota(cls, abc_id):
        with cls.app.app_context():
            result = json.loads(saas_quota_handles.get_quota_account(abc_id).get_data())
        return result
