import os
import logging

# Flask app configs


class Config(object):
    DEBUG = True
    BASE_HOST = "localhost"

    # Database attributes
    SQLALCHEMY_ECHO = True
    SQLALCHEMY_TRACK_MODIFICATIONS = True

    DB_USER = "saas"
    DB_NAME = "abcd"
    DB_HOST = "localhost"
    DB_PORT = 6432

    # Tvm attributes
    TVM_ID = "2028908"
    TVM_ALLOWED_CLIENTS = (None,)
    TVM_DESTINATIONS = (None,)
    TVM_ENABLE = False

    # Logging attributes
    PYTHONUNBUFFERED = True
    ERRORBOOSTER_LOGBROKER_TOPIC = "saas/errorbooster/infra-saas"

    ENVIRONMENT_TYPE = "BASE"

    # Provider attributes
    SAAS_PROVIDER_IDS = ['b44a0e54-0a5e-424a-bd61-b632952753da', '1ae09b4f-091b-481f-af89-10f01b9adf14']


    @property
    def DATABASE_PASSWORD(self):
        p = os.getenv("DATABASE_PASSWORD")
        if not p:
            logging.warning("Database password was not found from env variable DATABASE_PASSWORD, will use default password: saassaas")
            p = "saassaas"
        return p

    @property
    def SQLALCHEMY_DATABASE_URI(self):
        db_host = "&".join(["host={}".format(host) for host in self.DB_HOST])
        return "postgresql+psycopg2://{}:{}@/{}?port={}&{}".format(self.DB_USER, self.DATABASE_PASSWORD, self.DB_NAME,
                                                                   self.DB_PORT, db_host)

    @property
    def TVM_SECRET(self):
        s = os.getenv("TVM_SECRET")
        if not s:
            logging.warning("TVM secret not found from env variable TVM_SECRET")
            s = "empty"
        return s


class TestingConfig(Config):
    DEBUG = True
    DB_HOST = ["sas-jfekj7il57ynihl3.db.yandex.net"]
    DB_NAME = "saas-abcd"
    TVM_ID = "2028908"
    TVM_ALLOWED_CLIENTS = (2023017, 2023015)
    ENVIRONMENT_TYPE = "TESTING"


class ProductionConfig(Config):
    DEBUG = True
    DB_HOST = ["vla-k9djvzjslvplqcfl.db.yandex.net", "sas-0j78dhmf9evml0gk.db.yandex.net", "vla-x2hu6eowo46di33q.db.yandex.net"]
    TVM_ID = "2028910"
    TVM_ALLOWED_CLIENTS = (2023017, 2023015)
    ENVIRONMENT_TYPE = "PRODUCTION"

