# -*- coding: utf-8 -*-
from flask import Blueprint, jsonify, request, current_app
from functools import wraps
from werkzeug.exceptions import Forbidden

from saas.tools.abcd.lib.tvm import get_tvm2_client


class BlueprintTvm(Blueprint):
    def __init__(self, blueprint_name, __name__):
        super().__init__(blueprint_name,__name__)

    def route(self, rule, **options):
        def decorator(f):
            @wraps(f)
            def wrapped_f(*args, **kwargs):
                if not self.check_request_ticket():
                    raise Forbidden('TVM check fails')
                return f(*args, **kwargs)
            super(BlueprintTvm, self).route(rule, **options)(wrapped_f)
            return wrapped_f

        return decorator

    def check_request_ticket(self):
        tvm = get_tvm2_client()
        return tvm.check_request_ticket()
