# -*- coding: utf-8 -*-
from logging.config import dictConfig


def prepare_logging(level='INFO'):
    return dictConfig(
        {
            'version': 1,
            'formatters': {'default': {
                'format': '[%(asctime)s] %(levelname)s in %(module)s: %(message)s',
            }},
            'handlers': {'wsgi': {
                'class': 'logging.StreamHandler',
                'stream': 'ext://flask.logging.wsgi_errors_stream',
                'formatter': 'default'
            }},
            'root': {
                'level': level,
                'handlers': ['wsgi']
            }
        }
    )
