# -*- coding: utf-8 -*-

from flask import Blueprint, jsonify, request
from functools import wraps
from werkzeug.exceptions import Forbidden

from saas.tools.abcd.lib.tvm import CheckTvm
from ticket_parser2.api.v1 import BlackboxClientId


class TvmClient(Blueprint):
    def __init__(self):
        super().__init__('tvm_client',__name__)
        self._tvm = CheckTvm(
            client_id = '',
            blackbox_client = BlackboxClientId.Prod,
            allowed_clients = (None,),
            secret = ''
        )

    def route(self, rule, **options):
        def decorator(f):
            @wraps(f)
            def wrapped_f():
                if not self.check_request_ticket():
                    raise Forbidden('TVM check fails')
                return f()
            super(TvmClient, self).route(rule, **options)(wrapped_f)
            return wrapped_f

        return decorator


    def check_request_ticket(self):
        return self._tvm.check_request_ticket()


