# -*- coding: utf-8 -*-
import flask
from flask import request
from tvm2 import TVM2
from tvm2.protocol import BlackboxClientId


class CheckTvm(TVM2):
    """
    TVM wrapper for flask
    """

    def check_request_ticket(self):
        ticket = request.headers.get('X-Ya-Service-Ticket')
        flask.current_app.logger.info('There is service ticket: %s', ticket)
        if not flask.current_app.config['TVM_ENABLE']:
            return True
        if not ticket:
            return False
        parsed_ticket = self.parse_service_ticket(ticket=ticket)
        if parsed_ticket:
            return True
        return False


def get_tvm2_client():
    return CheckTvm(
        client_id=flask.current_app.config['TVM_ID'],
        blackbox_client=BlackboxClientId.Prod,
        allowed_clients=flask.current_app.config['TVM_ALLOWED_CLIENTS'],
        secret="flask.current_app.config['TVM_SECRET']",
    )

