"""initial structure

Revision ID: 32496d597340
Revises:
Create Date: 2021-09-22 20:00:49.614597

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = '32496d597340'
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('author',
    sa.Column('passport_uid', sa.String(), nullable=False),
    sa.Column('staff_login', sa.String(), nullable=True),
    sa.PrimaryKeyConstraint('passport_uid'),
    sa.UniqueConstraint('passport_uid')
    )
    op.create_table('resource_unit',
    sa.Column('id', postgresql.UUID(as_uuid=True), nullable=False),
    sa.Column('key', sa.String(), nullable=True),
    sa.Column('base', sa.Integer(), nullable=True),
    sa.Column('power', sa.Integer(), nullable=True),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('key')
    )
    op.create_table('segment',
    sa.Column('id', postgresql.UUID(as_uuid=True), nullable=False),
    sa.Column('segmentation', sa.String(), nullable=False),
    sa.Column('key', sa.String(), nullable=True),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('key')
    )
    op.create_table('operation',
    sa.Column('id', postgresql.UUID(as_uuid=True), nullable=False),
    sa.Column('timestamp', sa.Integer(), nullable=True),
    sa.Column('author_id', sa.String(), nullable=True),
    sa.ForeignKeyConstraint(['author_id'], ['author.passport_uid'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('resource_type',
    sa.Column('id', postgresql.UUID(as_uuid=True), nullable=False),
    sa.Column('key', sa.String(), nullable=True),
    sa.Column('unit', sa.String(), nullable=True),
    sa.ForeignKeyConstraint(['unit'], ['resource_unit.key'], ),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('key')
    )
    op.create_table('account',
    sa.Column('id', postgresql.UUID(as_uuid=True), nullable=False),
    sa.Column('key', sa.String(), nullable=False),
    sa.Column('folder_id', postgresql.UUID(as_uuid=True), nullable=False),
    sa.Column('abc_service_id', sa.Integer(), nullable=False),
    sa.Column('display_name', sa.String(), nullable=True),
    sa.Column('free_tier', sa.Boolean(), nullable=True),
    sa.Column('deleted', sa.Boolean(), nullable=True),
    sa.Column('operation_id', postgresql.UUID(as_uuid=True), nullable=True),
    sa.Column('version', sa.Integer(), autoincrement=True, nullable=True),
    sa.ForeignKeyConstraint(['operation_id'], ['operation.id'], ),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('abc_service_id'),
    sa.UniqueConstraint('key')
    )
    op.create_table('provision',
    sa.Column('id', postgresql.UUID(as_uuid=True), nullable=False),
    sa.Column('account_id', postgresql.UUID(as_uuid=True), nullable=True),
    sa.Column('resource_key', sa.String(), nullable=True),
    sa.Column('provided_amount', sa.Integer(), nullable=False),
    sa.Column('allocated_amount', sa.Integer(), nullable=False),
    sa.Column('unit_key', sa.String(), nullable=True),
    sa.Column('operation_id', postgresql.UUID(as_uuid=True), nullable=True),
    sa.Column('quota_version', sa.Integer(), autoincrement=True, nullable=True),
    sa.ForeignKeyConstraint(['account_id'], ['account.id'], ),
    sa.ForeignKeyConstraint(['operation_id'], ['operation.id'], ),
    sa.ForeignKeyConstraint(['resource_key'], ['resource_type.key'], ),
    sa.ForeignKeyConstraint(['unit_key'], ['resource_unit.key'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('saas_service',
    sa.Column('id', postgresql.UUID(as_uuid=True), nullable=False),
    sa.Column('name', sa.String(), nullable=True),
    sa.Column('ctype', sa.String(), nullable=True),
    sa.Column('account_id', postgresql.UUID(), nullable=True),
    sa.Column('abc_service_quota', sa.Integer(), nullable=True),
    sa.Column('abc_service_user', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['account_id'], ['account.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('nanny_service',
    sa.Column('id', postgresql.UUID(as_uuid=True), nullable=False),
    sa.Column('name', sa.String(), nullable=True),
    sa.Column('saas_service_id', postgresql.UUID(as_uuid=True), nullable=True),
    sa.Column('account_id', postgresql.UUID(as_uuid=True), nullable=True),
    sa.ForeignKeyConstraint(['account_id'], ['account.id'], ),
    sa.ForeignKeyConstraint(['saas_service_id'], ['saas_service.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_table('segmentations',
    sa.Column('provision_id', postgresql.UUID(as_uuid=True), nullable=True),
    sa.Column('segment_id', postgresql.UUID(as_uuid=True), nullable=True),
    sa.ForeignKeyConstraint(['provision_id'], ['provision.id'], ),
    sa.ForeignKeyConstraint(['segment_id'], ['segment.id'], )
    )
    op.create_table('resource',
    sa.Column('id', postgresql.UUID(as_uuid=True), nullable=False),
    sa.Column('key', sa.String(), nullable=True),
    sa.Column('nanny_service_id', postgresql.UUID(), nullable=True),
    sa.Column('segment_id', postgresql.UUID(), nullable=True),
    sa.Column('resource_type_id', postgresql.UUID(), nullable=True),
    sa.Column('amount', sa.Integer(), nullable=True),
    sa.ForeignKeyConstraint(['nanny_service_id'], ['nanny_service.id'], ),
    sa.ForeignKeyConstraint(['resource_type_id'], ['resource_type.id'], ),
    sa.ForeignKeyConstraint(['segment_id'], ['segment.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table('resource')
    op.drop_table('segmentations')
    op.drop_table('nanny_service')
    op.drop_table('saas_service')
    op.drop_table('provision')
    op.drop_table('account')
    op.drop_table('resource_type')
    op.drop_table('operation')
    op.drop_table('segment')
    op.drop_table('resource_unit')
    op.drop_table('author')
    # ### end Alembic commands ###
