#include <saas/tools/calc_smautodegrade/params.pb.h>

#include <library/cpp/getoptpb/getoptpb.h>

#include <util/stream/output.h>
#include <util/string/printf.h>

int main(int argc, const char* argv[]) {
    NGetoptPb::TGetoptPbSettings getoptSettings;
    getoptSettings.DumpConfig = false;
    NUtils::TParams params = NGetoptPb::GetoptPbOrAbort(argc, argv, getoptSettings);

    auto m = params.GetMinSmm();
    auto q1 = params.GetLaMin() / params.GetCpuCount();
    auto q2 = params.GetLaMax() / params.GetCpuCount();

    auto s = m + q1 * (1 - m);
    auto e = q2 + m * (1 - s) / (1 - m);

    Cout << Sprintf("pron=smautodegrade_%4.2f_%4.2f_%4.2f_exp", s, e, m) << Endl;

    return 0;
}
