#pragma once
#include <saas/library/daemon_base/daemon/daemon.h>
#include <saas/library/daemon_base/daemon/base_http_client.h>
#include <saas/util/queue.h>
#include <saas/util/types/interval.h>

#include <search/idl/meta.pb.h>

struct TChartBuilderConfig: public IServerConfig {
    class TInterval : public ::TInterval<i32> {
    public:
        TInterval(i32 min, i32 max, const TString& name);
        const TVector<TString>& GetNames() const {
            return Names;
        }
        void SetNames(const TString& value);
        bool HasMin() const {
            return GetMin() != -::Max<i32>();
        }
        bool HasMax() const {
            return GetMax() != ::Max<i32>();
        }
    private:
        TVector<TString> Names;
    };
    THttpServerOptions ServerOptions;
    const TDaemonConfig& DaemonConfig;
    TString ReaskHost = "saas-dm-maps.yandex.net";
    ui16 ReaskPort = 80;
    TVector<TString> CTypes;
    TVector<TInterval> Intervals;

    const TDaemonConfig& GetDaemonConfig() const {
        return DaemonConfig;
    }

    TSet<TString> GetModulesSet() const {
        return TSet<TString>();
    }

    TChartBuilderConfig(const TServerConfigConstructorParams& params);
};

class THttpChartServer : public THttpServer, public THttpServer::ICallBack {
public:
    THttpChartServer(const TChartBuilderConfig& config)
        : THttpServer(this, config.ServerOptions)
        , Config(config)
    {
    }

    virtual TClientRequest* CreateClient();
private:
    const TChartBuilderConfig& Config;
};

class TChartBuilder: public IServer {
public:
    typedef TChartBuilderConfig TConfig;
    typedef TCollectServerInfo TInfoCollector;

    TChartBuilder(const TConfig& config)
        : Config(config)
        , Server(config)
    {

    }

    void Run() {
        Server.Start();
    }

    void Stop(ui32 /*rigidStopLevel*/, const TCgiParameters* /*cgiParams*/) {
        Server.Stop();
    }

    const TConfig& GetConfig() const {
        return Config;
    }

private:
    const TConfig& Config;
    THttpChartServer Server;
};
