import os
import sys
import logging
from datetime import datetime
from library.python import resource

from saas.tools.devo.devo.core.util import load_plugins, get_config
sys.dont_write_bytecode = True

config_key = '/config.ini'
r = resource.find(config_key).decode("utf-8")

def main():
    config = get_config(r)

    # logging.basicConfig(filename=config.get("common", "log_path") % datetime.today().strftime("%Y-%m-%d"),
    #                 level=logging.INFO,
    #                 format='%(asctime)s:%(module)s:%(name)s:%(levelname)s:%(message)s')
    #
    # logging.debug("DeVo Robot startup")
    print("DeVo Robot startup")

    plugins = load_plugins(config)
    print("Number of plugins = {}".format(len(plugins)))

    for p in plugins:
        try:
            p.main()
        except Exception as e:
            print("Exception in plugin {}:".format(p.title))
            print(e)
            # logging.error("Exception in plugin {}:".format(p.title))
            # logging.exception(e)

    # logging.debug("DeVo Robot shutdown")
    print("DeVo Robot shutdown")

if __name__ == "__main__":
    main()

