class BasePlugin(object):
    config = None
    ptype = None
    title = 'Base plugin'
    desc = 'Some text about base plugin'
    sentry_module = None

    def __init__(self, config):
        self.config = config

    def setup(self):
        """called before the plugin is asked to do anything"""
        raise NotImplementedError

    def main(self):
        """called when the plugin is asked to do anything"""
        raise NotImplementedError

    def teardown(self):
        """called to allow the plugin to free anything"""
        raise NotImplementedError

    def _config_getlist(self, section, option):
        return [i.strip() for i in self.config.get(section, option).split(',')]

    def _config_getintlist(self, section, option):
        return [
                int(i.strip())
                for i in self.config.get(section, option).split(',')
               ]

