import importlib
import configparser
import requests
import re

from urllib.parse import urlparse
from urllib.parse import urlunparse

CONFIG = None

def load_plugins(config):
    plugins = []
    for sec in config.sections():
        if not sec.startswith('plugins.'):
            continue
        pname = sec.split('.')[1]
        m = importlib.import_module('saas.tools.devo.devo.plugins.' + pname + '.index')
        pclassname = ''.join([i.title() for i in pname.split('_')])
        i = getattr(m, pclassname)(config)
        i.setup()
        plugins.append(i)
    return plugins


def get_config(config_file):
    global CONFIG
    if not CONFIG:
        CONFIG = configparser.ConfigParser()
        CONFIG.read_string(config_file)
    return CONFIG

