from dataclasses import dataclass


class ServiceType:
    KV = 'kv'
    # SEARCH = 'search'

    ALL = [KV]


@dataclass
class AppConfig:
    service_name: str
    service_ctype: str
    service_type: str

    read_check_start_lag: int
    read_check_lag: int
    server_port: int

    saas_abc_group_id: int
    saas_tvm_id: int

    debug: bool

    @classmethod
    def parse(cls, config_data: dict) -> 'AppConfig':
        service = config_data.get('service', {})
        service_name = service.get('name')
        service_ctype = service.get('ctype')
        service_type = service.get('type')

        if not all([service_name, service_ctype, service_type]):
            raise ValueError('Error, ensure the service key is present and correctly set')

        if service_type not in ServiceType.ALL:
            raise ValueError(f'Service type "{service_type}" is not supported. Expected to be one of {ServiceType.ALL}')

        return AppConfig(
            service_name,
            service_ctype,
            service_type,

            config_data.get('read_check_start_lag', 60),
            config_data.get('read_check_lag', 30),
            config_data.get('port', 8080),

            config_data.get('saas_abc_group_id', 664),
            config_data.get('saas_tvm_id', 2011146),

            config_data.get('debug', False)
        )
