from infra.yasm.unistat import global_unistat, SuffixType, AggregationType
from saas.library.python.deploy_manager_api import SaasService


class ReadStateTracker:
    def __init__(self, service: SaasService) -> None:
        self._yasm_hole = global_unistat.create_float(
            name=f'saas_canary-{service.ctype}-{service.name}-reader_errors',
            suffix=SuffixType.Absolute,
            aggregation_type=AggregationType.Sum
        )
        self.on_success()

    def on_error(self) -> None:
        self._yasm_hole.push(1)

    def on_success(self) -> None:
        self._yasm_hole.reset()
        self._yasm_hole.push(0)
