import logging

from cached_property import cached_property_with_ttl

from saas.library.python.deploy_manager_api import SaasService
from saas.tools.devops.canary.writer.configs import RTYServerConfig


class SaasServiceWrapper:
    def __init__(self, service: str, ctype: str) -> None:
        self._service = SaasService(ctype, service)

    @property
    def name(self) -> str:
        return self._service.name

    @property
    def ctype(self) -> str:
        return self._service.ctype

    @cached_property_with_ttl(ttl=60*15)
    def rtyserver_config(self) -> RTYServerConfig:
        logging.info('Trying to download and parse rtyserver config for %s, %s', self.name, self.ctype)
        content = self._service.get_config('rtyserver.conf-common').content
        return RTYServerConfig.from_content(content)
