#!/bin/bash
set -e

# Requires evironment variables UID_ROBOT_SAAS_DUTY and UID_ROBOT_SAAS_FRSH_DUTY (available on yav.yandex-team.ru).
#
# Usage examples:
#
# * Create duty events from 2019-04-29T12:00:00 to 2019-05-06T12:00:00
#   ./create_duty_event.sh salmin 2019-04-29T12:00
#
# * Create duty events from 2019-04-29T12:00:00 to 2019-05-01T07:00:00
#   ./create_duty_event.sh salmin 2019-04-29T12:00
#
# * Dry run to check API calls
# ./create_duty_event.sh -d salmin 2019-04-29T12:00

CALENDAR_API="calendar-api.tools.yandex.net/internal"

POST_TEMPLATE=$(cat <<-'EOF'
    { 
        "type": "user",
        "startTs": "START_TIMESTAMP",
        "endTs": "END_TIMESTAMP",
        "name": "Дежурство. Дежурный: DUTY_LOGIN@",
        "location": "",
        "description": "",
        "isAllDay": false, 
        "availability": "available",
        "layerId": LAYER_ID,
        "attendees": ["DUTY_LOGIN@yandex-team.ru"],
        "organizer": "ORGANIZER_LOGIN@yandex-team.ru",
        "participantsCanInvite": true,
        "participantsCanEdit": true,
        "othersCanView": true
    }
EOF
)

die() {
    echo "$@"
    exit 1
}

run_curl() {
    dry=$1 ; shift
    if [ z$dry = ztrue ] ; then
        echo curl "$@"
    else
        curl "$@" | jq .
    fi
}

[ -n "$UID_ROBOT_SAAS_DUTY" ] || die "Please set environment variable UID_ROBOT_SAAS_DUTY"
[ -n "$UID_ROBOT_SAAS_FRSH_DUTY" ] || die "Please set environment variable UID_ROBOT_SAAS_FRSH_DUTY"

dry_run="false"

if [ "z$1" = "z-d" -o "z$1" = "z--dry-run" ] ; then
    dry_run="true"
    shift;
fi

duty_login=$(echo "$1" | sed -e 's/@.*//') ; shift
start="$1" ; shift
len_string="${1:-1w}"

len_num="${len_string%w}" && [ "z$len_string" != "z$len_num" ] && len=$((len_num * 60 * 60 * 24 * 7))
len_num="${len_string%d}" && [ "z$len_string" != "z$len_num" ] && len=$((len_num * 60 * 60 * 24))
len_num="${len_string%h}" && [ "z$len_string" != "z$len_num" ] && len=$((len_num * 60 * 60))
len_num="${len_string%m}" && [ "z$len_string" != "z$len_num" ] && len=$((len_num * 60))

[ -n "$len" -a "$len" -gt 0 ] || die "Invalid event length: '$len' seconds derived from input '$len_string'"

start_unix=$(date -d "$start" +%s)
end_unix=$((start_unix + len))

start=$(date --iso-8601=seconds -d "@$start_unix")
end=$(date --iso-8601=seconds -d "@$end_unix")

post="$(echo "$POST_TEMPLATE" | \
    sed -e "\
        s/START_TIMESTAMP/$start/g; \
        s/END_TIMESTAMP/$end/g; \
        s/DUTY_LOGIN/$duty_login/g; \
        s/ORGANIZER_LOGIN/robot-saas-duty/g; \
        s/LAYER_ID/44427/g; \
    " \
)"
run_curl $dry_run -s "$CALENDAR_API/create-event.json?uid=$UID_ROBOT_SAAS_DUTY" -H 'Content-Type: application/json' -d "$post"

post="$(echo "$POST_TEMPLATE" | \
    sed -e "\
        s/START_TIMESTAMP/$start/g; \
        s/END_TIMESTAMP/$end/g; \
        s/DUTY_LOGIN/$duty_login/g; \
        s/ORGANIZER_LOGIN/robot-saas-frsh-duty/g; \
        s/LAYER_ID/44752/g; \
    " \
)"
run_curl $dry_run -s "$CALENDAR_API/create-event.json?uid=$UID_ROBOT_SAAS_FRSH_DUTY" -H 'Content-Type: application/json' -d "$post"
