#!/bin/bash

[[ $# -lt 1 ]] && { echo -e "Usage:\n\t$0 <text file>\n\t$0 <dump command>\nExamples:\n\t$0 eventlog.txt\n\t$0 eventlog.txt.gz\n\t$0 evlogdump /ssd/yrum-0913/current-eventlog-mmeta-8028 -s \$(date +%s -d 2017-09-13T17:58:50+0300)000000 -e \$(date +%s -d 2017-09-13T18:01+0300)000000 -i"; exit 1; }

# время выполнения можно брать $16 (собственное) или $18 (то, по которому считается таймаут)
[[ -z $F ]] && F=18

# Создаём директорию, если надо
SRC=$@
if [[ $# -eq 1 ]] && [[ -f $1 ]] && [[ ! -x $1 ]]; then
    if [[ $SRC == *".gz" ]]; then
        SRC="gunzip -c $SRC | fgrep"
    else
        SRC="cat $SRC | fgrep"
    fi
    WORKDIR=$1"_"$F"_stats"
fi
[[ -n $WORKDIR ]] || WORKDIR=.
[[ -d $WORKDIR ]] || mkdir $WORKDIR 


# ================================================================
#
set +e

set -x
eval "$SRC SubSourceOk" | head -n 200000 | awk -v FS='[\t]' -v OFS='\t' '{print $10 "_" $2, $3, $4, $5, $6, $7, $8, $9, $11, $12, $13, "-";}' > $WORKDIR/oks_.txt

eval "$SRC SubSourceError" | head -n 200000 | awk -v FS='[\t]' -v OFS='\t' '{print $12 "_" $2, $3, $4, $5, $6, $7, "-", $8, $13, $14, $16, $15;}' >> $WORKDIR/oks_.txt
# $16 и $15 поменяны преднамеренно; $15 - это текст сообщения об ошибке

eval "$SRC SubSourceRequest" | head -n 200000 | awk -v OFS='\t'  ' { print $9 "_" $2, $1, $3, $4, $5, $6, $7, substr($8,0,200);}' | sort -k1 > $WORKDIR/req.txt

pushd $WORKDIR
cat oks_.txt | sort -k1 > answ.txt; rm oks_.txt

join -t $'\t' req.txt answ.txt > join.txt

sources=$(cut -f 4 join.txt | sort -nu | xargs)
search_sources=$(cut -f 4,15 join.txt | egrep -v -e '.-aux$' -e '.-info$' | cut -f 1 | sort -nu | xargs)

set +x;

# Общая статистика по источникам
for i in $sources; do >&2 echo "Making result-$i.txt"; { echo -e 'qua\trow#\t$'$F'(ms)\tstatus\treqid_logframe\ttime'; cat join.txt | awk -v IFS='\t' '($4 == '"$i"')' | sort -t $'\t' -nk$F | awk -v IFS='\t' -v OFS='\t' '{ print $'"$F"', $15, $0; }' | cat -n > tmp.txt; awk -v IFS='\t' -v OFS='\t' -v NSTR=$(cat tmp.txt | wc -l) '{print int($1*1000.0/NSTR), $0;}' tmp.txt | sort -unk1 | awk '$1 <= 30 && $1 % 5 == 0 || $1 % 50 == 0 || $1 > 950 && $1 % 5 == 0 || $1 >= 980' | awk '{q=sprintf("%.1f%%",$1/10.0); $1=""; print q, $0;}'; } | column -t > result-$i.txt; done

# Детально по типам запросов
for MASK in search allfactors fetch; do for i in $search_sources; do >&2 echo "Making result-$MASK-$i.txt"; { echo -e 'qua\trow#\t$'$F'(ms)\tstatus\treqid_logframe\ttime'; cat join.txt | awk -v IFS='\t' '($4 == '"$i"') && ($15~/'"$MASK"'/)' | sort -t $'\t' -nk$F | awk -v IFS='\t' -v OFS='\t' '{ print $'"$F"', $15, $0; }' | cat -n > tmp.txt; awk -v IFS='\t' -v OFS='\t' -v NSTR=$(cat tmp.txt | wc -l) '{print int($1*1000.0/NSTR), $0;}' tmp.txt | sort -unk1 | awk '$1 <= 30 && $1 % 5 == 0 || $1 % 50 == 0 || $1 > 950 && $1 % 5 == 0 || $1 >= 980' | awk '{q=sprintf("%.1f%%",$1/10.0); $1=""; print q, $0;}'; } | column -t > result-$MASK-$i.txt; done; done

rm tmp.txt answ.txt join.txt req.txt
popd

