#!/usr/bin/env python
import asyncio
import logging

from saas.tools.devops.fban.config import FBanConfig
from saas.tools.devops.fban.fban import FBanChecker
from saas.tools.devops.fban.utils import setup_logging


async def main() -> None:
    config = FBanConfig.parse()
    setup_logging(config)

    try:
        await FBanChecker(config).run()
    except Exception:
        logging.exception('Uncaught error occurred in FBanChecker')


if __name__ == '__main__':
    asyncio.run(main())
