#!/bin/bash

DM_HOST=http://saas-dm.yandex.net

curl -s "$DM_HOST/get_services" > services.json

ctypes=( stable stable_kv )
#ctypes=( prestable stable_middle_kv stable_market stable_hamster )
stypes=( searchproxy indexerproxy rtyserver )

for ctype in "${ctypes[@]}"
do
    for stype in "${stypes[@]}"
    do
	echo "-- check $ctype $stype"
        jq -r "(.$ctype.$stype | keys)[]" services.json | while read srv_name; do
		curl -s "$DM_HOST/broadcast?command=get_info_server&filter=%24status%24.status&ignore_unknown_path=true&service_type=$stype&ctype=$ctype&service=$srv_name" | jq -r "(.[\"$srv_name\"] | keys)[]" | cut -f 1 -d ':' | while read hh; do nip=`host $hh | wc -l`; if [[ $nip -gt 1 ]]; then echo $hh; fi; sleep 0.1; done
	done
	sleep 1
    done
done

echo '-- Done.'
