#!/bin/bash

set -e

if [ -z ${5+x} ]; then
    echo "Example: ./make_backup.sh prestable my_service hahn //home/saas/ferryman-prestable/path/to/ferryman [SEGMENT_SIZE]"
    exit
fi

CTYPE=$1
SERVICE=$2
PROXY=$3
FERRYMAN_PATH=$4
SEGMENT_SIZE=$5
TMP_PATH="$1_$2"

export YT_PROXY=$PROXY

./get_standalone_indexer --ctype $CTYPE --service $SERVICE --path $TMP_PATH --debug

echo "Downloading dict.dict"
sky get -d "$TMP_PATH/" -wup rbtorrent:72fc143c77c59e674b95530813123b8808388975

TIMESTAMP=`yt read --table "${FERRYMAN_PATH}/ytpull/master.full{key}" --format=dsv | tail -1 | cut -d '=' -f 2`
echo "Timestamp for backup: $TIMESTAMP"

read -p "Press [Enter] key to start backup..."

pushd $TMP_PATH

./standalone_indexer yt ./configs/rtyserver.conf-common --service $SERVICE --searchmap ./configs/searchmap.json --proxy $PROXY --src "$FERRYMAN_PATH/ytpull/full.$TIMESTAMP" --dst-dir "$FERRYMAN_PATH/pan" --dst "$FERRYMAN_PATH/pan/data/$SERVICE/$TIMESTAMP.blob" --tmp-dir "$FERRYMAN_PATH/pan/tmp.$TIMESTAMP" --verbose --timestamp $TIMESTAMP --processor message --publish --publish-path "$FERRYMAN_PATH/dishes" --cut-includes false --add-extra-timestamp --segment-size $SEGMENT_SIZE --dict-path ./dict.dict -E ./configs/environment -V SHARD_MIN=0 -V SHARD_MAX=65533

popd
