#!/bin/bash

#
# Create sandbox resource from current wc
#

REV=$(svn info . | awk '/^Revision:/{print $2}')
PATH=$(svn info . | awk '/^URL:/{print $2}')
[[ $REV -gt 0 ]] && [[ -n $PATH ]] || { >&2 echo "Svn info failed"; exit 1; }
[[ -z $(svn diff --summarize) ]] || { >&2 echo "Working copy has local modifications"; exit 1; }

ya upload --skynet --ttl=720 -d="DevOps tools from ${PATH}@${REV}" *
