import argparse

from dataclasses import dataclass
from typing import Optional


@dataclass
class AppConfig:
    zk_base_path: str

    logfile: Optional[str]
    logrotate_max_bytes: int
    logrotate_backup_count: int
    debug: bool = False

    @classmethod
    def parse_args(cls) -> 'AppConfig':
        parser = argparse.ArgumentParser()

        parser.add_argument('--zk-base-path', type=str, default='/saas10/logbroker/dc_checker',
                            help='Base path to dc checker results in ZK')

        parser.add_argument('--logfile', type=str, default=None, help='Log file path')
        parser.add_argument('--logrotate-max-bytes', type=int, default=1024*1024*256,
                            help='Logrotate: max log file size in bytes')
        parser.add_argument('--logrotate-backup-count', default=2, type=int, help='Logrotate: backup count')

        parser.add_argument('--debug', action='store_true', help='Should show debug level logs or not')

        args = parser.parse_args()

        return AppConfig(
            args.zk_base_path,
            logfile=args.logfile,
            logrotate_max_bytes=args.logrotate_max_bytes,
            logrotate_backup_count=args.logrotate_backup_count,
            debug=args.debug
        )
