from saas.tools.devops.lib23.nanny_helpers import NannyService
from saas.tools.devops.lib23.saas_entity import SaaSEntity, STAGING_SAAS_CTYPES
import search.tools.devops.libs.utils as u
import logging

u.logger_setup(1)
e = SaaSEntity()
all_staging_services = e.filter_iterate(saas_ctypes=STAGING_SAAS_CTYPES)

yp_services = []
non_yp_services = []

for s in all_staging_services:
    ns = NannyService(s['nanny_service'])
    if ns.is_yp_lite():
        yp_services.append("{}/{}".format(s['saas_service'], s['nanny_service']))
    else:
        non_yp_services.append("{}/{}".format(s['saas_service'], s['nanny_service']))

logging.info("Services in YP: %s", yp_services)
logging.info("Services not in YP: %s", non_yp_services)
