#!/usr/bin/python

import six

YES_STRINGS = frozenset({'yes', 'ok', 'da', 'y'})
NO_STRINGS = frozenset({'no', 'net', 'n'})


def wait_for_manual_confirm(info_string, yes_strings=YES_STRINGS):
    while True:
        user_input = six.moves.input(info_string)
        if user_input.lower() in yes_strings:
            return


def ask_yes_or_no(info_string, yes_strings=YES_STRINGS, no_strings=NO_STRINGS):
    while True:
        user_input = six.moves.input(info_string)
        if user_input.lower() in yes_strings:
            return True
        elif user_input.lower() in no_strings:
            return False
