# coding: utf-8

import yt.wrapper as yt
import yt.yson as yson

YT_CLUSTER = 'arnold'
YT_PATH = '//home/saas/gencfg-data'
HOSTS_TABLE_LINK = yt.YPath('{}/current_hosts'.format(YT_PATH))
INSTANCES_TABLE_LINK = yt.YPath('{}/current_instances'.format(YT_PATH))

STATS_SLOTS_REPORT = 'SAAS/resources/Slots'
CPU_MULTIPLIER = 40
MEM_MULTIPLIER = 2 ** 30
SLOT_FLAVORS = {
    'slots2x10': {'cpu': 2 * CPU_MULTIPLIER, 'mem': 10 * MEM_MULTIPLIER},
    'slots2x20': {'cpu': 2 * CPU_MULTIPLIER, 'mem': 20 * MEM_MULTIPLIER},
    'slots2x25': {'cpu': 2 * CPU_MULTIPLIER, 'mem': 25 * MEM_MULTIPLIER},
    'slots3x20': {'cpu': 3 * CPU_MULTIPLIER, 'mem': 20 * MEM_MULTIPLIER},
    'slots3x25': {'cpu': 3 * CPU_MULTIPLIER, 'mem': 25 * MEM_MULTIPLIER},
    'slots3x30': {'cpu': 3 * CPU_MULTIPLIER, 'mem': 30 * MEM_MULTIPLIER},
    'slots4x20': {'cpu': 4 * CPU_MULTIPLIER, 'mem': 20 * MEM_MULTIPLIER},
    'slots4x25': {'cpu': 4 * CPU_MULTIPLIER, 'mem': 25 * MEM_MULTIPLIER},
    'slots4x30': {'cpu': 4 * CPU_MULTIPLIER, 'mem': 30 * MEM_MULTIPLIER},
    'slots6x20': {'cpu': 6 * CPU_MULTIPLIER, 'mem': 20 * MEM_MULTIPLIER},
    'slots6x25': {'cpu': 6 * CPU_MULTIPLIER, 'mem': 25 * MEM_MULTIPLIER},
    'slots6x30': {'cpu': 6 * CPU_MULTIPLIER, 'mem': 30 * MEM_MULTIPLIER},
    'slots8x25': {'cpu': 8 * CPU_MULTIPLIER, 'mem': 25 * MEM_MULTIPLIER},
    'slots8x30': {'cpu': 8 * CPU_MULTIPLIER, 'mem': 30 * MEM_MULTIPLIER},
    'slots8x40': {'cpu': 8 * CPU_MULTIPLIER, 'mem': 40 * MEM_MULTIPLIER},
}
HOST_TABLE_SCHEMA = [
    {'name': 'hostname',            'type': 'string',   'required': True},
    {'name': 'dc',                  'type': 'string',   'required': True},
    {'name': 'switch',              'type': 'string',   'required': True},
    {'name': 'cpu_model',           'type': 'string',   'required': True},
    {'name': 'cpu_cores',           'type': 'uint8',    'required': True},
    {'name': 'cpu_power_total',     'type': 'uint16',   'required': True},
    {'name': 'cpu_power_available', 'type': 'int16',    'required': True},
    {'name': 'ram_total',           'type': 'uint64',   'required': True},
    {'name': 'ram_available',       'type': 'uint64',   'required': True},
    {'name': 'ssd_total',           'type': 'uint64',   'required': True},
    {'name': 'hdd_total',           'type': 'uint64',   'required': True},
    {'name': 'ssd_available',       'type': 'int64',    'required': True},
    {'name': 'hdd_available',       'type': 'int64',    'required': True},
    {'name': 'noindexing',          'type': 'boolean',  'required': False},
    {'name': 'net',                 'type': 'uint32',   'required': True},
]
INSTANCE_TABLE_SCHEMA = [
    {'name': 'hostname',            'type': 'string',   'required': True},
    {'name': 'group',               'type': 'string',   'required': True},
    {'name': 'is_saas_group',       'type': 'boolean',  'required': True},
    {'name': 'cpu_class',           'type': 'string',   'required': True},
    {'name': 'cpu_guarantee',       'type': 'uint16',   'required': True},
    {'name': 'cpu_limit',           'type': 'uint16',   'required': True},
    {'name': 'memory_guarantee',    'type': 'uint64',   'required': True},
    {'name': 'memory_limit',        'type': 'uint64',   'required': True},
    {'name': 'allocated_ssd',       'type': 'uint64',   'required': True},
    {'name': 'allocated_hdd',       'type': 'uint64',   'required': True},
    {'name': 'noindexing',          'type': 'boolean',  'required': False},
    {'name': 'network_critical',    'type': 'boolean',  'required': False},
]

for action in {'read', 'write'}:
    for storage in {'ssd', 'hdd'}:
        INSTANCE_TABLE_SCHEMA.extend([
            {'name': '{}_io_{}_limit'.format(storage, action), 'type': 'uint64', 'required': True},
            {'name': '{}_io_ops_{}_limit'.format(storage, action), 'type': 'uint32', 'required': True},
        ])


def prepare_yt_data(hosts_data):
    hosts_info = []
    instances_info = []
    host_fields = [column['name'] for column in HOST_TABLE_SCHEMA]
    instance_fields = [column['name'] for column in INSTANCE_TABLE_SCHEMA]

    for host_record in hosts_data:
        instances = host_record.pop('instances')
        hosts_info.append({k: host_record[k] for k in host_fields})
        for instance in instances:
            instance['hostname'] = host_record['hostname']
            instances_info.append({k: instance[k] for k in instance_fields})
    return hosts_info, instances_info


def get_hosts_table(date):
    """
    :type date: datetime.date
    :type: yt.TablePath
    """
    schema = yson.YsonList(HOST_TABLE_SCHEMA)
    schema.attributes['strict'] = True
    schema.attributes['key_columns'] = 'hostname'
    return yt.TablePath('{}/hosts/{}'.format(YT_PATH, date.isoformat()), attributes={'schema': schema})


def get_instance_table(date):
    """
    :type date: datetime.date
    :type: yt.TablePath
    """
    schema = yson.YsonList(INSTANCE_TABLE_SCHEMA)
    schema.attributes['strict'] = True
    return yt.TablePath('{}/instances/{}'.format(YT_PATH, date.isoformat()), attributes={'schema': schema})
