#!/bin/bash
set -e
[[ -z $1 ]] && echo "Usage: run_loadtest.sh loadtest20190101.yaml" && exit -2
[[ -d $1 ]] && CFG="$1.yaml" || CFG=$1
[[ -f $1 ]] && WC=$(echo $1 | sed 's:.yaml::') || WC=$1
WORKDIR=$(basename $WC)

source static/helpers.sh

SERVICE=$(fgrep target_mmeta $CFG | cut -f2 -d:)
BLINOV=$(get_blinov_for_service "$SERVICE")

echo "Copy and paste the following commands."
echo
echo "To RUN:"
echo "========"
echo "sky run -Up --timeout 30 'set -x; echo ./run.sh plan.txt.gz \"'\''\" -m plan -T 1200 -M 1.0 \"'\''\" > ~/$WORKDIR/start_hook.sh' $BLINOV"
echo
echo "or"
echo
echo "sky run -Up --timeout 30 'set -x; echo ./run.sh plan.txt.gz \"'\''\" -m plan -T 1200 -M 1.0 \"'\''\" \"'\''\"&some_arg=123\"'\''\" > ~/$WORKDIR/start_hook.sh' $BLINOV"
echo
echo "To STOP:"
echo "========"
echo "sky run -Up --timeout 30 --cqudp 'pkill -TERM -u $(whoami) d-executor' $BLINOV"
echo
