#!/bin/bash

[[ "${BASH_SOURCE[0]}" != "$0" ]] || { echo -e "ERROR - please use 'source' to include this script:\n\n\tsource $0\n"; exit -2; }

get_nanny_conf_helper() {
   set -x
   get_nanny_conf -f $1
}

get_blinov_for_service() {
   SERVICE=$1
   echo $SERVICE | fgrep -q '@' || {
       set -e
       CONF=$(get_nanny_conf_helper $1)
       echo "C@$CONF"
       return 0
   }
   echo $SERVICE | fgrep -vq 'S@' && {
       echo $SERVICE
       return 0
   }
   RET=$(echo $SERVICE | sed -r 's/(.*)S@([-0-9a-zA-Z_]*)(.*)/echo \1C@$(get_nanny_conf --stdout-error \2)\3 \n/eg')
   echo $RET | >&2 fgrep 'ERROR<'  && return -1
   echo $RET
}
