#!/bin/bash

[[ -z $1 ]] && { echo "No argument provided"; exit -2; }
[[ -d $1 ]] || { echo "Directory $1 does not exist"; exit -2; }

cd $1

LTIME=$(stat -c %Z start_hook.sh)

while true    
do
   ATIME=$(stat -c %Z start_hook.sh)

   if [[ "$ATIME" != "$LTIME" ]]
   then
       echo $(date --iso-8601=seconds) Starting task.
       bash start_hook.sh &
       LTIME=$ATIME
   fi
   sleep 5
done
