#!/bin/bash

date --iso-8601=seconds
set -e
set -x

[[ -f $1 ]] || exit 1
[[ -z $IPORT ]] && IPORT=$(cat .instance_port | xargs)
[[ -n $IPORT ]] || exit 1

EXTRA_CGI=$(echo "$3" | sed 's:&:\\\&:g') # escaping for the argument of Sed

# Clear cache
curl -gs "http://$(hostname -f):$IPORT/yandsearch?text=sunmicrosystems&nocache=42"

gunzip -c $1 | sed -e 's: %IPORT% :'" $IPORT "':g' -e 's%&internal=1%&'"$EXTRA_CGI"'%g' | ./d-planner -o 1.plan -t accesslog -h $(hostname -f) -f '%{msec}t %p %r'

nohup bash -c './d-executor -p 1.plan -c '"$2"' 2>/dev/null | ./d-dumper -a >stat.txt' &
disown
