#!/bin/bash
set -e
[[ -z $1 ]] && echo "Usage: upload_wc.sh loadtest20190101.yaml" && exit -2
[[ -d $1 ]] && CFG="$1.yaml" || CFG=$1
[[ -f $1 ]] && WC=$(echo $1 | sed 's:.yaml::') || WC=$1
[[ -z $state ]] && state=1 # ansible-like 'target state'

source static/helpers.sh

upload() {
    set -x
    sky upload -Up $WC /home/$(whoami)/ "$BLINOV"
    touch $WC/.uploaded
}

remove() {
    set -x
    sky run -Up "rm -r /home/$(whoami)/$WC && echo OK || >&2 echo errno: \$?" "$BLINOV"
    # .uploaded in kept in place (it is needed only for wc creation)
}

SERVICE=$(fgrep target_mmeta $CFG | cut -f2 -d:)
echo "Resolving service $SERVICE"
BLINOV=$(get_blinov_for_service "$SERVICE")
echo "Uploading executors to service $BLINOV"

if [[ $state -eq 0 ]]; then
    remove
else
    upload
fi

