from dataclasses import dataclass
from pathlib import Path
from typing import List


@dataclass(frozen=True)
class DisasterAlertsConfig:
    owners: List[str]
    jinja_templates_root_dir: Path

    alerts_template_key: str = 'saas_disaster_alerts'
    alerts_macros_template_key: str = 'saas_disaster_alerts.macros'
    services_template_key: str = 'saas_disaster_alerts_services'

    warden_component_name: str = 'saas'
    warden_use_test_spi: bool = False

    def get_template_file_path(self, template_key: str) -> Path:
        return self.jinja_templates_root_dir / f'{template_key}.jinja2'
