
import search.tools.devops.libs.nanny_services as ns
from search.tools.devops.libs.modify_topology import modify_topology

def update_topology(nanny_service, new_topology_tag, do_activate_service=False):

    response = ns.get_service_runtime_attrs(nanny_service)
    topology = response.json()["content"]["instances"]["extended_gencfg_groups"]["groups"]
    tags = set()
    for group in topology:
        tags.add(group['release'])

    snapshots_in_both_topologies = modify_topology([nanny_service], topologies_to_add=['tags/{}'.format(new_topology_tag)], topologies_to_remove=[], commit=True, print_diff=True)
    print list(tags)
    snapshots_in_new_topology = modify_topology([nanny_service], topologies_to_add=[], topologies_to_remove=list(tags), commit=True, print_diff=True)

    print snapshots_in_both_topologies, snapshots_in_new_topology

    if do_activate_service:
        ns.set_active_snapshot_state(
            service,
            snapshot_id,
            recipe='common',
            prepare_recipe='common',
            comment="Bump to topology : {}".format(new_topology),
        )
    return snapshots_in_new_topology[nanny_service]
