#include <saas/tools/dump_ddk/params.pb.h>

#include <saas/rtyserver/components/ddk/ddk_config.h>
#include <saas/rtyserver/components/ddk/ddk_fields.h>
#include <saas/rtyserver/components/ddk/ddk_manager.h>
#include <saas/rtyserver/components/erf/erf_disk.h>

#include <library/cpp/getoptpb/getoptpb.h>

int main(int argc, const char* argv[]) {
    NGetoptPb::TGetoptPbSettings getoptSettings;
    getoptSettings.DumpConfig = false;
    NUtils::TParams params = NGetoptPb::GetoptPbOrAbort(argc, argv, getoptSettings);

    try {
        TDDKComponentConfig ddkConfig;
        TRTYErfDiskManager::TCreationContext ctx(TPathName{params.GetSegmentPath()}, "indexddk.rty", &GetDDKFields(), true);
        TRTYErfDiskManager erfManager(ctx, "DDK");
        TRTYDDKManager ddkManager(&erfManager, ddkConfig, false);

        Y_ENSURE(ddkManager.Open());

        if (params.GetPrintHeader()) {
            Cout <<
                "DocId\t"
                "Deadline\t"
                "Version\t"
                "TimeLiveStart\t"
                "Identifier\t"
                "SourceWithNewVersion\t"
                "ParsedEntitiesHash\t"
                "StreamId\n";
        }

        for (ui32 docId = 0, docCount = ddkManager.GetDocumentsCount(); docId < docCount; ++docId) {
            Cout
                << docId << "\t"
                << ddkManager.GetDeadline(docId) << "\t"
                << ddkManager.GetVersion(docId) << "\t"
                << ddkManager.GetTimeLiveStart(docId) << "\t"
                << ddkManager.GetIdentifier(docId).Quote() << "\t"
                << ddkManager.GetSourceWithNewVersion(docId) << "\t"
                << ddkManager.GetParsedEntitiesHash(docId) << "\t"
                << ddkManager.GetStreamId(docId) << "\n";
        }

        ddkManager.Close();

        return 0;

    } catch (...) {
        Cerr << "ERROR: " << CurrentExceptionMessage() << Endl;
        return 1;
    }
}

