#include "mapper.h"
#include <util/folder/filelist.h>
#include <util/folder/path.h>

void TSegmentsMapper::Do(NYT::TTableReader<NYT::TNode>* input, NYT::TTableWriter<NYT::TNode>* output) {
    for (; input->IsValid(); input->Next()) {
        NYT::TNode row = input->GetRow();
        TFsPath filePath(row["name"].AsString());
        if (filePath.GetName().Contains("fullarc")) {
            row["secondary_segment_id"] = filePath.Parent().GetName();
            output->AddRow(row);
        }
    }
}
REGISTER_MAPPER(TSegmentsMapper);
