import logging
import sys


def get_logger(debug_file):
    logging.basicConfig(
        level=logging.DEBUG,
        format=u'[%(levelname)s\t%(asctime)s]\t%(message)s',
        datefmt=u'%Y-%m-%d %H:%M:%S',
        filename=debug_file
    )
    logger = logging.getLogger(__name__)

    info_handler = logging.StreamHandler(stream=sys.stdout)
    info_handler.setLevel(logging.INFO)
    logger.addHandler(info_handler)
    return logger
