#include <saas/tools/flat2multipart/params.pb.h>

#include <kernel/multipart_archive/convert/flat2multipart.h>

#include <library/cpp/getoptpb/getoptpb.h>
#include <library/cpp/logger/global/global.h>

int main(int argc, const char* argv[]) {
    NGetoptPb::TGetoptPbSettings getoptSettings;
    getoptSettings.DumpConfig = false;
    NUtils::TParams params = NGetoptPb::GetoptPbOrAbort(argc, argv, getoptSettings);
    InitGlobalLog2Console();
    try {
        using namespace NRTYArchive;

        auto arcPath = TFsPath(params.GetInputDir()) / (params.GetArcPrefix() + "arc");
        auto dirPath = TFsPath(params.GetInputDir()) / (params.GetArcPrefix() + "dir");
        auto multipartPath = TFsPath(params.GetOutputDir()) / params.GetMultipartPrefix();

        TMultipartConfig config;
        config.PartSizeLimit = params.GetPartSize();
        config.Compression = FromString<IArchivePart::TType>(params.GetCompression());
        config.CompressionParams.Algorithm = FromString<IArchivePart::TConstructContext::TCompressionParams::TAlgorithm>(params.GetAlgorithm());
        config.CompressionParams.Level = params.GetLevel();
        config.CompressionParams.ExtParams.CodecName = params.GetCodec();
        config.CompressionParams.ExtParams.BlockSize = params.GetBlockSize();
        config.CompressionParams.ExtParams.LearnSize = params.GetLearnSize();

        ConvertFlatArchiveToMultipart(dirPath, arcPath, multipartPath, config);

        return 0;

    } catch (...) {
        ERROR_LOG << CurrentExceptionMessage() << Endl;
        return 1;
    }
}


