#include "wrapper.h"

#include <util/stream/output.h>
#include <util/folder/dirut.h>
#include <util/generic/yexception.h>
#include <util/generic/string.h>

namespace NRtyInfraTests {

    TWrapper::TWrapper() {
        //
    }
    int TWrapper::Main(int argc, char **argv) {
        try {
            ProcessArg(argc, argv);
            ParseScript();
            Run();
            Cout << "Completed successfully!" << Endl;
        } catch (...) {
            Cerr << CurrentExceptionMessage() << Endl;
            return 1;
        }
        return 0;
    }
    void TWrapper::ProcessArg(int argc, char **argv) {
        Cout << "tester path is: " << argv[0] << Endl;
        VERIFY_AND_THROW(argc > 1, "script path is not set");
        Cout << "script path is: " << argv[1] << Endl;
        VERIFY_AND_THROW(NFs::Exists(argv[1]), "script path is not exist");
        ScriptPath = argv[1];
    }
    void TWrapper::ParseScript() {
        ScriptContainer.ReadScript(ScriptPath.data());
    }
    void TWrapper::Run() {
        Machine.Run(ScriptContainer);
    }
}
