#include <library/cpp/neh/neh.h>

const TDuration TIMEOUT = TDuration::Seconds(10);

void SendRequest(const TString& request) {
    NNeh::TResponseRef resp = NNeh::Request(request)->Wait(TIMEOUT);
    Y_ENSURE(resp, "No response. Request: " << request);
    Y_ENSURE(!resp->IsError(), "Got an error response: " << resp->GetErrorText());
    Cout << resp->Data << Endl;
}

int main(int argc, const char* argv[]) {
    try {
        Y_ENSURE(argc > 1);
        SendRequest(argv[1]);
        return 0;

    } catch (...) {
        Cerr << CurrentExceptionMessage() << Endl;
        return 1;
    }
}

