#pragma once

#include <saas/library/daemon_base/daemon/info.h>
#include <saas/library/daemon_base/daemon/base_http_client.h>

#include <util/datetime/base.h>
#include "storage.h"

class TStaticServiceMetrics;

namespace NRTY {

    class TClient: public TBaseHttpClient {
    private:
        TProcessorsStorage& Processors;
        TInstant StartTime;
    public:
        TClient(TStaticServiceMetrics& /*metrics*/, TProcessorsStorage& processors);

        TString GetInfo() const;
    public:
        virtual void GetMetrics(IOutputStream& out) const;
        virtual bool Reply(void* /*ThreadSpecificResource*/);
        const TServerRequestData& GetRD() const {
            return RD;
        }

        const TBlob& GetPost() const {
            return Buf;
        }

    };

}
