#include "config.h"

#include <saas/library/daemon_base/config/daemon_config.h>

#include <util/folder/dirut.h>
#include <util/system/fs.h>
#include <library/cpp/logger/global/global.h>
#include <saas/rtyserver/logging/rty_index.h>

#define GET_VALUE(name) { if (directives.find(#name) != directives.end()) name = directives.Value(#name, name); }

namespace NRTY {
    class TAnyDirective: public TYandexConfig::Directives {
    public:
        TAnyDirective(): Directives(false) {}
    };

    typedef TAnyDirective ProcessorsConfig;

        TConfig::TConfig(const TServerConfigConstructorParams& params)
        : DaemonConfig(*params.Daemon)
        , ProcessorsConfig(*this, "ProcessorsConfig")
        , Preprocessor(*params.Preprocessor)
    {
        InitFromString(~params.Text);
    }


    void TConfig::InitFromString(const char* configText) {
        TAnyYandexConfig serverConfig;
        if (!serverConfig.ParseMemory(configText)) {
            ythrow yexception() << "Bad config text";
        }

        TYandexConfig::Section* proxySection = serverConfig.GetFirstChild("Server");
        CHECK_WITH_LOG(proxySection);
        TYandexConfig::TSectionsMap sections = proxySection->GetAllChildren();

        Init(proxySection->GetDirectives());

        TYandexConfig::TSectionsMap::const_iterator iter = sections.find("HttpOptions");
        VERIFY_WITH_LOG(iter != sections.end(), "No HttpOptions section");
        HttpOptionsConfig.Init(iter->second->GetDirectives());
        HttpOptionsConfig.KeepAliveEnabled = false;
        ProcessorsConfig.Init(*this, sections);
    }

    void TConfig::Init(const TYandexConfig::Directives& /*directives*/) {
    }

    TString TConfig::ToString() const {
        TString s;
        TStringOutput so(s);
        so << DaemonConfig.ToString("DaemonConfig") << Endl;
        so << "<Server>" << Endl;
        so << HttpOptionsConfig.ToString("HttpOptions");
        ProcessorsConfig.ToString(&so);
        so << "</Server>" << Endl;
        return s;
    }

}
