#pragma once

#include <saas/tools/processors_server/abstract/processor.h>
#include <saas/library/daemon_base/config/daemon_config.h>
#include <saas/library/daemon_base/module/module.h>

#include <library/cpp/http/server/options.h>

#include <util/generic/noncopyable.h>
#include <util/generic/ptr.h>
#include <util/generic/utility.h>
#include <util/string/util.h>
#include <util/system/dynlib.h>

namespace NRTY {
    class TConfig: public IServerConfig {
    public:
        TConfig(const TServerConfigConstructorParams& params);
        void InitFromString(const char* configText);
        void Init(const TYandexConfig::Directives& directives);
        TString ToString() const;

        TSet<TString> GetModulesSet() const {
            return TSet<TString>();
        }

        const TDaemonConfig& GetDaemonConfig() const {
            return DaemonConfig;
        }

        const TDaemonConfig::THttpOptions& GetHttpOptionsConfig() const {
            return HttpOptionsConfig;
        }

        const TPluginConfigs<IProcessorConfig>& GetProcessorsConfig() const {
            return ProcessorsConfig;
        }

    private:
        TDaemonConfig::THttpOptions HttpOptionsConfig;
        const TDaemonConfig& DaemonConfig;
        TPluginConfigs<IProcessorConfig> ProcessorsConfig;
        TString ProcessorsLog;
    protected:
        const TConfigPatcher& Preprocessor;
    };

}
