#pragma once

#include "client.h"

#include <saas/library/daemon_base/daemon/info.h>
#include <saas/library/daemon_base/daemon/controller.h>
#include <saas/library/daemon_base/metrics/servicemetrics.h>

#include <library/cpp/http/server/http.h>

#include <util/generic/ptr.h>
#include "messages.h"
#include "storage.h"
#include "config.h"

namespace NRTY {

    class TServer: public THttpServer::ICallBack, public IMessageProcessor, public IServer {
    private:
        const NRTY::TConfig& Config;
        THolder<THttpServer> Server;

        TStaticServiceMetrics Metrics;
        TProcessorsStorage Processors;
    public:
        typedef NRTY::TConfig TConfig;
        typedef TMessageCollectCrawlerInfo TInfoCollector;

    public:
        virtual TClientRequest* CreateClient();

        virtual void OnFailRequestEx(const TFailLogData& d) {
            ERROR_LOG << "Request failed: " << d.failstate << " for url: " << d.url << Endl;
        }

        virtual void OnException() {
            ERROR_LOG << "Exception occured in http server!!(" << CurrentExceptionMessage() << ")" << Endl;
        }

        virtual void OnMaxConn() {
            WARNING_LOG << "Connections count is maximum" << Endl;
        }

        virtual void OnListenStart() {
            INFO_LOG << "Listening started... OK" << Endl;
        }

        virtual void OnListenStop() {
            INFO_LOG << "Listening stopped... OK" << Endl;
        }

        virtual void OnWait() {
        }

        const NRTY::TConfig& GetConfig() const {
            return Config;
        }

        const TStaticServiceMetrics& GetMetrics() const {
            return Metrics;
        }

        TServer(const NRTY::TConfig& config);

        void Run();
        void Stop(ui32 rigidStopLevel = 0, const TCgiParameters* cgiParams = nullptr);
        //IMessageProcessor()
        virtual bool Process(IMessage* message) override;
        virtual TString Name() const override;
    };

}
