#include <search/idl/meta.pb.h>

#include <search/session/compression/report.h>

#include <kernel/querydata/idl/querydata_structs_client.pb.h>

#include <library/cpp/string_utils/base64/base64.h>

#include <util/generic/string.h>
#include <util/stream/input.h>
#include <util/stream/output.h>

void PrintAttr(IOutputStream& out, const TString& attr) {
    NQueryData::TSourceFactors sf;
    Y_VERIFY(sf.ParseFromString(attr));
    out << sf.Utf8DebugString() << Endl;
}

int main() {
    TString line = Cin.ReadAll();
    NMetaProtocol::TReport report;
    Y_VERIFY(report.ParseFromString(line));
    NMetaProtocol::Decompress(report);
    for (auto& grouping : report.GetGrouping()) {
        for (auto& group : grouping.GetGroup()) {
            for (auto& doc : group.GetDocument()) {
                if (doc.HasArchiveInfo()) {
                    for (auto& attr : doc.GetArchiveInfo().GetGtaRelatedAttribute()) {
                        if (attr.GetKey().StartsWith("QDSaaS:")) {
                            PrintAttr(Cout, Base64Decode(attr.GetValue()));
                        }
                    }
                }
            }
        }
    }
    return 0;
}

