#include <kernel/saas_trie/idl/trie_key.h>

#include <library/cpp/getopt/small/last_getopt.h>

#include <google/protobuf/text_format.h>

#include <util/generic/string.h>
#include <library/cpp/string_utils/quote/quote.h>
#include <util/stream/input.h>
#include <util/stream/output.h>

struct TConfig {
    bool NotPacked = false;

    void Init(int argc, const char* argv[]) {
        auto makeOpt = [](TString name, TString help, bool required = true) {
            NLastGetopt::TOpt opt;
            opt.AddLongName(name);
            opt.Help(help);
            if (required) {
                opt.Required();
            }
            return opt;
        };
        NLastGetopt::TOpts opts;
        opts.AddOption(makeOpt("notpacked", "input keys are not packed", false).StoreResult(&NotPacked, true).NoArgument());
        opts.AddHelpOption('h');

        NLastGetopt::TOptsParseResult parser(&opts, argc, argv);
    }
};

int main(int argc, const char* argv[]) {
    TConfig config;
    config.Init(argc, argv);

    TString line;
    while (Cin.ReadLine(line)) {
        NSaasTrie::TComplexKey key;
        NSaasTrie::DeserializeFromCgi(key, line, !config.NotPacked);
        Cout << key.Utf8DebugString() << '\n';
    }
    return 0;
}

