import logging
import logging.config
import os

from future.moves.configparser import ConfigParser
from library.python import resource

"""
Если файлы конфигов лежат рядом с бинарником, то используются они.
Иначе - используются конфиги по-умолчанию, зашитые в ресурсы бинарника (app.ini и logging.ini из репозитория).
Необходимо для прохождения импорт-тестов!!!
"""

config_app = ConfigParser(defaults=os.environ, strict=False)
if os.path.exists('./app.ini'):
    config_app.read('./app.ini')
else:
    config_app.read_string(resource.find('app.ini').decode('utf-8'))

if os.path.exists('./logging.ini'):
    logging.config.fileConfig('./logging.ini')
else:
    config_logging = ConfigParser(strict=False)
    config_logging.read_string(resource.find('logging.ini').decode('utf-8'))
    logging.config.fileConfig(config_logging)

logger = logging.getLogger('main')
signal_logger = logging.getLogger('signal')
