from typing import Any, List, Optional, Union

from multidict import MultiDict


def parse_cgi_params(cgi_params: str) -> MultiDict:
    params = MultiDict()
    cgi_params = cgi_params.replace(' ', '')
    for cgi_param in cgi_params.split('&'):
        if not cgi_param:
            continue
        name, *value = cgi_param.split('=')
        params.add(name, '='.join(value))
    return params


def get_value_by_field_name(obj,
                            field: Union[str, List[str]]) -> Optional[Any]:
    if type(field) == str:
        field = [field]

    for current_field in field:
        try:
            obj = getattr(obj, current_field)
        except AttributeError:
            return None
    return obj


def get_attr_value_by_key(data: List[dict],
                               key: str) -> Optional[str]:
    for item in data:
        if item['Key'] == key:
            return item['Value']
