#include "common_context.h"

#include <util/string/vector.h>
#include <util/generic/set.h>

namespace {

    template<typename TStoreResult>
    NLastGetopt::TOpt& AddOption(NLastGetopt::TOpts& opts, const TString& propName, const TString& help, const TString& arg, TStoreResult* target) {
        return opts.AddLongOption(propName, help).Required()
            .RequiredArgument(arg).StoreResult(target);
    }

    template<typename TStoreResult>
    NLastGetopt::TOpt& AddOption(NLastGetopt::TOpts& opts, const TString& propName, const TString& help, const TString& arg, const TString& defaultValue,
        TStoreResult* target)
    {
        return AddOption(opts, propName, help, arg, target).DefaultValue(defaultValue);
    }

}

void NSaas::AddCommonOpts(NLastGetopt::TOpts& opts, NSaas::TCommonContext& context, const bool allowPrototext) {
    AddOption(opts, "mr-server", "Server name", "<url>", &context.MRServer);
    AddOption(opts, "src-table", "Source table name", "<table name>", &context.SrcTable);
    AddOption(opts, "dst-table", "Destination table name", "<table name>", &context.DstTable);
    AddOption(opts, "master-table", "Master table name", "<table name>", &context.MasterTable);
    AddOption(opts, "chunk-timestamp", "Chunk timestamp", "<timestamp>", &context.SlaveTableTimestamp);

    TSet<NSaas::ShardingType> shardingTypes;
    TShardsDispatcher::IShardingRule::TFactory::GetRegisteredKeys(shardingTypes);
    shardingTypes.erase(NSaas::Broadcast); // Unusable on indexing

    const TString shardingTypesStr = "{" + JoinStrings(shardingTypes.cbegin(), shardingTypes.cend(), "|") + "}";
    AddOption(opts, "sharding-type", "Sharding type", shardingTypesStr, &context.ShardingType);

    if (allowPrototext) {
        opts.AddLongOption("prototext-output", "Dump result as prototext (for debug)").Optional().NoArgument().SetFlag(&context.ProtoText);
    }
}
