#include "proto_dump_impl.h"

#include <robot/jupiter/library/tables/shards_prepare.h>


namespace NRtDoc {
    IProtoDumper::TPtr IProtoDumper::Create(bool deepParse, bool useHex) {
        return new TProtoDumper(deepParse, useHex);
    }

    void TProtoDumper::RegisterJupiter(TJsonStringPrintersRegistry& registry) {
        auto tables = NJupiter::TShardsPrepareTables::Clientless();
        registry.RegisterTable(tables.GetAnnCountsTable(0));
        registry.RegisterTable(tables.GetContentAttrsTable(0));
        registry.RegisterTable(tables.GetCalculatedAttrsTable(0));
        registry.RegisterTable(tables.GetCalculatedAttrsWithKeyInvDocChunkMappingSingleChunkTable(0));
        registry.RegisterTable(tables.GetAttrsKeyInvTable(0));
        registry.RegisterTable(tables.GetCountsKeyInvTable(0));
        registry.RegisterTable(tables.GetErfGlobalLumpsTable(0));
        registry.RegisterTable(tables.GetErfDocLumpsTable(0));
        registry.RegisterTable(tables.GetErfHerfFeaturesTable(0));
        registry.RegisterTable(tables.GetExternalRelevAttrsTable(0));
        registry.RegisterTable(tables.GetFactorAnnCountsTable(0));
        registry.RegisterTable(tables.GetKeyInvCountsTable(0));
        registry.RegisterTable(tables.GetLinkAnnCountsTable(0));
        registry.RegisterTable(tables.GetMetaTagsCountsTable(0));
        registry.RegisterTable(tables.GetPantherDssmTermsTable(0));
        registry.RegisterTable(tables.GetPantherDssmTermsTable(0));
        registry.RegisterTable(tables.GetPantherDssmUrlTitleEmbeddingsTable(0));
        registry.RegisterTable(tables.GetPantherTable(0));
        registry.RegisterTable(tables.GetStatsTableLink());
        registry.RegisterTable(tables.GetWalrusWithKeyInvDocChunkMappingSingleChunkTable(0));
    }
}
