#pragma once

#include <library/cpp/json/json_writer.h>

#include <robot/jupiter/library/rtdoc/protos/lumps.pb.h>

namespace NRtDoc {
    class IProtoDumper: public TThrRefBase {
    public:
        virtual ~IProtoDumper() = default;

        virtual bool IsKnown(const TString& tableName) = 0;
        virtual NJson::TJsonValue ToJson(const NJupiter::TMapType& cell) = 0;

    public:
        using TPtr = TIntrusivePtr<IProtoDumper>;

    public:
        static TPtr Create(bool deepParse, bool useHex);
    };
}
