#pragma once

#include <kernel/idx_ops/types.h>

#include <util/stream/input.h>
#include <util/generic/string.h>

namespace NSaas {
    using TRequestId = NIdxOps::TRequestId;

    class TDolbilkaPlan {
    public:
        struct TQueryData {
            TRequestId RequestId;
            TString Query;
        };

    public:
        static TStringBuf TrimQuery(TStringBuf src);
    };

    class TDolbilkaPlanReader {
    public:
        enum class EPlanFormat {
            PlainQueries,
            TsvWithIds
        };

        EPlanFormat Mode = EPlanFormat::PlainQueries;
        ui32 MaxItemsToRead = 0;

    public:
        void ReadAll(IInputStream& inp, TVector<TDolbilkaPlan::TQueryData>& plan);
    };

}
